<?php
require '../../config/db.php';
require '../../helpers/jwt_handler.php';

$data = json_decode(file_get_contents("php://input"));
$stmt = $pdo->prepare("SELECT * FROM users WHERE email = ?");
$stmt->execute([$data->email]);
$user = $stmt->fetch();

if ($user && password_verify($data->password, $user['password'])) {
    $token = generateJWT($user['id']);
    echo json_encode(["token" => $token]);
} else {
    http_response_code(401);
    echo json_encode(["message" => "Invalid credentials"]);
}
