<?php
require '../../config/db.php';

$data = json_decode(file_get_contents("php://input"));

if (!isset($data->email) || !isset($data->password)) {
    http_response_code(400);
    echo json_encode(["message" => "Invalid input"]);
    exit;
}

$stmt = $pdo->prepare("INSERT INTO users (email, password) VALUES (?, ?)");
$stmt->execute([$data->email, password_hash($data->password, PASSWORD_BCRYPT)]);
echo json_encode(["message" => "User registered"]);
